/**
 * \file: mlink_wfd_decoder_plugin_logging.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MLINK WiFi-Display Decoder plug-in
 *
 * \component: mlink
 *
 * \author: Ajay Kumar Sahoo ajaykumar.sahoo@in.bosch.com
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \history
 * 0.1 Ajay Kumar Sahoo Initial version
 *
 ***********************************************************************/
#include "mlink_wfd_decoder_plugin_logging.h"

void WiFiDisplayDecoderLogError(VNCWiFiDisplayDecoder *pDecoder,const char *msg)
  {
      int severity=0;
      pDecoder->factoryInitInfo->pDecoderSupportingAPI->vncWiFiDisplayDecoderFactoryLog(pDecoder->factoryInitInfo->decoderFactoryContext,severity,msg);
  }

void WiFiDisplayDecoderLogWarn(VNCWiFiDisplayDecoder *pDecoder,const char *msg)
  {
      int severity=10;
      pDecoder->factoryInitInfo->pDecoderSupportingAPI->vncWiFiDisplayDecoderFactoryLog(pDecoder->factoryInitInfo->decoderFactoryContext,severity,msg);
  }

void WiFiDisplayDecoderLogInfo(VNCWiFiDisplayDecoder *pDecoder,const char *msg)
  {
      int severity=30;
      pDecoder->factoryInitInfo->pDecoderSupportingAPI->vncWiFiDisplayDecoderFactoryLog(pDecoder->factoryInitInfo->decoderFactoryContext,severity,msg);
  }

void WiFiDisplayDecoderLogVerbose(VNCWiFiDisplayDecoder *pDecoder,const char *msg)
  {
      int severity=100;
      pDecoder->factoryInitInfo->pDecoderSupportingAPI->vncWiFiDisplayDecoderFactoryLog(pDecoder->factoryInitInfo->decoderFactoryContext,severity,msg);
  }
